/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.viewer;

import filenet.sim.api.VWScenarioDefinition;
import filenet.sim.api.VWScenarioWorkflowDefinition;
import filenet.sim.toolkit.viewer.VWSIMAnimatorDataModel;
import filenet.sim.toolkit.viewer.VWSIMAnimatorQueue;
import filenet.sim.toolkit.viewer.VWSIMAnimatorUser;
import filenet.sim.toolkit.viewer.VWSIMAnimatorWorkflow;
import filenet.vw.api.VWException;
import filenet.vw.api.VWQueueDefinition;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.util.Vector;

public class VWSIMAnimatorScenario {
    private VWSIMAnimatorDataModel m_dataModel = null;
    private VWScenarioDefinition m_scenarioDefinition = null;
    private VWScenarioWorkflowDefinition[] m_scenarioWorkflowDefinitions = null;
    private String m_name = null;
    private Vector m_workflows = null;
    private Vector m_queues = null;
    private Vector m_users = null;
    private int m_launchedCount = 0;
    private int m_activeCount = 0;
    private int m_completedCount = 0;
    private int m_overdueCount = 0;
    private double m_cost = 0.0;
    private double m_averageCost = 0.0;
    private long m_minCycleTime = 0L;
    private long m_maxCycleTime = 0L;
    private long m_aveCycleTime = 0L;

    public VWSIMAnimatorScenario(VWSIMAnimatorDataModel dataModel, VWScenarioDefinition scenarioDef) throws Exception {
        this.m_dataModel = dataModel;
        this.m_scenarioDefinition = scenarioDef;
        this.m_workflows = new Vector();
        this.m_queues = new Vector();
        this.m_users = new Vector();
        if (this.m_scenarioDefinition != null) {
            this.m_name = scenarioDef.getName();
            this.m_scenarioWorkflowDefinitions = this.m_scenarioDefinition.getWorkflows();
            if (this.m_scenarioWorkflowDefinitions != null && this.m_scenarioWorkflowDefinitions.length > 0) {
                for (int i = 0; i < this.m_scenarioWorkflowDefinitions.length; ++i) {
                    this.m_workflows.add(new VWSIMAnimatorWorkflow(this, this.m_scenarioWorkflowDefinitions[i].getWorkflowDefinition(), Integer.toString(i)));
                }
            }
        }
    }

    public VWSIMAnimatorWorkflow getWorkflow(int workClassId) {
        if (this.m_workflows != null) {
            Object obj = null;
            VWSIMAnimatorWorkflow workflow = null;
            for (int i = 0; i < this.m_workflows.size(); ++i) {
                obj = this.m_workflows.elementAt(i);
                if (obj == null || !(obj instanceof VWSIMAnimatorWorkflow)) continue;
                workflow = obj;
                if (((VWSIMAnimatorWorkflow)obj).getWorkClassId() != workClassId) continue;
                return workflow;
            }
        }
        return null;
    }

    public Vector getAllMaps() {
        Vector allMaps = new Vector();
        if (this.m_workflows != null) {
            Object obj = null;
            Vector maps = null;
            for (int i = 0; i < this.m_workflows.size(); ++i) {
                obj = this.m_workflows.elementAt(i);
                if (obj == null || !(obj instanceof VWSIMAnimatorWorkflow) || (maps = ((VWSIMAnimatorWorkflow)obj).getMaps()) == null) continue;
                allMaps.addAll(maps);
            }
        }
        return allMaps;
    }

    public String getName() {
        return this.m_name;
    }

    public VWSIMAnimatorDataModel getDataModel() {
        return this.m_dataModel;
    }

    public Vector getWorkflows() {
        return this.m_workflows;
    }

    public Vector getQueues() {
        return this.m_queues;
    }

    public VWSIMAnimatorQueue findQueue(String name) {
        if (name != null && this.m_queues != null && this.m_queues.size() > 0) {
            Object obj = null;
            for (int i = 0; i < this.m_queues.size(); ++i) {
                VWSIMAnimatorQueue queue;
                obj = this.m_queues.elementAt(i);
                if (obj == null || !(obj instanceof VWSIMAnimatorQueue) || (queue = (VWSIMAnimatorQueue)obj).getName() == null || VWStringUtils.compare(queue.getName(), name) != 0) continue;
                return queue;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VWSIMAnimatorQueue addQueue(VWSIMAnimatorQueue queue) {
        if (this.m_queues == null) {
            this.m_queues = new Vector();
        }
        if (queue == null) {
            return null;
        }
        String queueName = queue.getName();
        Vector vector = this.m_queues;
        synchronized (vector) {
            Object obj = null;
            VWSIMAnimatorQueue aQueue = null;
            String aName = null;
            if (queueName != null) {
                boolean bInserted = false;
                for (int i = 0; i < this.m_queues.size(); ++i) {
                    obj = this.m_queues.elementAt(i);
                    if (obj == null || !(obj instanceof VWSIMAnimatorQueue) || (aName = (aQueue = (VWSIMAnimatorQueue)obj).getName()) == null || VWStringUtils.compare(queueName, aName) > 0) continue;
                    this.m_queues.add(i, queue);
                    bInserted = true;
                    break;
                }
                if (!bInserted) {
                    this.m_queues.add(queue);
                }
            }
        }
        return null;
    }

    public VWSIMAnimatorQueue newQueue(VWQueueDefinition queueDef) {
        VWSIMAnimatorQueue queue = new VWSIMAnimatorQueue(queueDef);
        return this.addQueue(queue);
    }

    public VWSIMAnimatorQueue newQueue(String name) {
        VWSIMAnimatorQueue queue = new VWSIMAnimatorQueue(name);
        return this.addQueue(queue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VWSIMAnimatorUser findUser(String name) {
        Vector vector = this.m_users;
        synchronized (vector) {
            if (name != null && this.m_users != null && this.m_users.size() > 0) {
                Object obj = null;
                for (int i = 0; i < this.m_users.size(); ++i) {
                    VWSIMAnimatorUser user;
                    obj = this.m_users.elementAt(i);
                    if (obj == null || !(obj instanceof VWSIMAnimatorUser) || (user = (VWSIMAnimatorUser)obj).getName() == null || VWStringUtils.compare(user.getName(), name) != 0) continue;
                    return user;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VWSIMAnimatorUser newUser(String name) {
        if (this.m_users == null) {
            this.m_users = new Vector();
        }
        VWSIMAnimatorUser user = new VWSIMAnimatorUser(name);
        String userName = user.getName();
        Vector vector = this.m_users;
        synchronized (vector) {
            Object obj = null;
            VWSIMAnimatorUser aUser = null;
            String aName = null;
            if (userName != null) {
                boolean bInserted = false;
                for (int i = 0; i < this.m_users.size(); ++i) {
                    obj = this.m_users.elementAt(i);
                    if (obj == null || !(obj instanceof VWSIMAnimatorUser) || (aName = (aUser = (VWSIMAnimatorUser)obj).getName()) == null || VWStringUtils.compare(userName, aName) > 0) continue;
                    this.m_users.add(i, user);
                    bInserted = true;
                    break;
                }
                if (!bInserted) {
                    this.m_users.add(user);
                }
            }
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getUsers() {
        Vector vector = this.m_users;
        synchronized (vector) {
            return this.m_users;
        }
    }

    public String toString() {
        String str = this.getName();
        if (str != null) {
            return str;
        }
        return new String("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clearStatistics() {
        int i;
        Object obj;
        if (this.m_workflows != null) {
            obj = null;
            Object maps = null;
            for (i = 0; i < this.m_workflows.size(); ++i) {
                obj = this.m_workflows.elementAt(i);
                if (obj == null || !(obj instanceof VWSIMAnimatorWorkflow)) continue;
                ((VWSIMAnimatorWorkflow)obj).clearStatistics();
            }
        }
        if (this.m_queues != null) {
            obj = null;
            for (int i2 = 0; i2 < this.m_queues.size(); ++i2) {
                obj = this.m_queues.elementAt(i2);
                if (obj == null || !(obj instanceof VWSIMAnimatorQueue)) continue;
                ((VWSIMAnimatorQueue)obj).clearStatistics();
            }
        }
        Vector vector = this.m_users;
        synchronized (vector) {
            if (this.m_users != null) {
                Object obj2 = null;
                for (i = 0; i < this.m_users.size(); ++i) {
                    obj2 = this.m_users.elementAt(i);
                    if (obj2 == null || !(obj2 instanceof VWSIMAnimatorUser)) continue;
                    ((VWSIMAnimatorUser)obj2).clearStatistics();
                }
            }
        }
    }

    public synchronized int getLaunchedCount() {
        return this.m_launchedCount;
    }

    public synchronized int getActiveCount() {
        return this.m_activeCount;
    }

    public synchronized int getCompletedCount() {
        return this.m_completedCount;
    }

    public synchronized int getOverdueCount() {
        return this.m_overdueCount;
    }

    public synchronized double getCost() {
        return this.m_cost;
    }

    public synchronized double getAverageCost() {
        return this.m_averageCost;
    }

    public synchronized long getMinCycleTime() {
        return this.m_minCycleTime;
    }

    public synchronized long getMaxCycleTime() {
        return this.m_maxCycleTime;
    }

    public synchronized long getAverageCycleTime() {
        return this.m_aveCycleTime;
    }

    public synchronized void setLaunchedCount(int count) {
        this.m_launchedCount = count;
    }

    public synchronized void setActiveCount(int count) {
        this.m_activeCount = count;
    }

    public synchronized void setCompletedCount(int count) {
        this.m_completedCount = count;
    }

    public synchronized void setOverdueCount(int count) {
        this.m_overdueCount = count;
    }

    public synchronized void setCost(double cost) {
        this.m_cost = cost;
    }

    public synchronized void setAverageCost(double cost) {
        this.m_averageCost = cost;
    }

    public synchronized void setMinCycleTime(long time) {
        this.m_minCycleTime = time;
    }

    public synchronized void setMaxCycleTime(long time) {
        this.m_maxCycleTime = time;
    }

    public synchronized void setAverageCycleTime(long time) {
        this.m_aveCycleTime = time;
    }

    void releaseResources() {
        int i;
        Object obj = null;
        this.m_dataModel = null;
        this.m_scenarioDefinition = null;
        if (this.m_scenarioWorkflowDefinitions != null) {
            for (i = 0; i < this.m_scenarioWorkflowDefinitions.length; ++i) {
                this.m_scenarioWorkflowDefinitions[i] = null;
            }
            this.m_scenarioWorkflowDefinitions = null;
        }
        if (this.m_workflows != null) {
            for (i = 0; i < this.m_workflows.size(); ++i) {
                obj = this.m_workflows.elementAt(i);
                if (obj == null || !(obj instanceof VWSIMAnimatorWorkflow)) continue;
                ((VWSIMAnimatorWorkflow)obj).releaseResources();
            }
            this.m_workflows.removeAllElements();
            this.m_workflows = null;
        }
        if (this.m_users != null) {
            for (i = 0; i < this.m_users.size(); ++i) {
                obj = this.m_users.elementAt(i);
                if (obj == null || !(obj instanceof VWSIMAnimatorUser)) continue;
                ((VWSIMAnimatorUser)obj).releaseResources();
            }
            this.m_users.removeAllElements();
            this.m_users = null;
        }
        if (this.m_queues != null) {
            for (i = 0; i < this.m_queues.size(); ++i) {
                obj = this.m_queues.elementAt(i);
                if (obj == null || !(obj instanceof VWSIMAnimatorQueue)) continue;
                ((VWSIMAnimatorQueue)obj).releaseResources();
            }
            this.m_queues.removeAllElements();
            this.m_queues = null;
        }
        obj = null;
    }

    void writeScenarioDefinitionToFile(String filename) throws VWException {
        if (this.m_scenarioDefinition != null && filename != null) {
            this.m_scenarioDefinition.writeToFile(filename);
        }
    }
}

